"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var rotation_exports = {};
__export(rotation_exports, {
  applyRotationToSnapshotShapes: () => applyRotationToSnapshotShapes,
  getRotationSnapshot: () => getRotationSnapshot
});
module.exports = __toCommonJS(rotation_exports);
var import_tlschema = require("@tldraw/tlschema");
var import_utils = require("@tldraw/utils");
var import_Mat = require("../primitives/Mat");
var import_utils2 = require("../primitives/utils");
var import_Vec = require("../primitives/Vec");
function getRotationSnapshot({ editor }) {
  const selectedShapes = editor.getSelectedShapes();
  const selectionRotation = editor.getSelectionRotation();
  const selectionBounds = editor.getSelectionRotatedPageBounds();
  const {
    inputs: { originPagePoint }
  } = editor;
  if (!selectionBounds) {
    return null;
  }
  const selectionPageCenter = selectionBounds.center.clone().rotWith(selectionBounds.point, selectionRotation);
  return {
    selectionPageCenter,
    initialCursorAngle: selectionPageCenter.angle(originPagePoint),
    initialSelectionRotation: selectionRotation,
    shapeSnapshots: selectedShapes.map((shape) => ({
      shape: (0, import_utils.structuredClone)(shape),
      initialPagePoint: editor.getShapePageTransform(shape.id).point()
    }))
  };
}
function applyRotationToSnapshotShapes({
  delta,
  editor,
  snapshot,
  stage
}) {
  const { selectionPageCenter, shapeSnapshots } = snapshot;
  editor.updateShapes(
    shapeSnapshots.map(({ shape, initialPagePoint }) => {
      const parentTransform = (0, import_tlschema.isShapeId)(shape.parentId) ? editor.getShapePageTransform(shape.parentId) : import_Mat.Mat.Identity();
      const newPagePoint = import_Vec.Vec.RotWith(initialPagePoint, selectionPageCenter, delta);
      const newLocalPoint = import_Mat.Mat.applyToPoint(
        // use the current parent transform in case it has moved/resized since the start
        // (e.g. if rotating a shape at the edge of a group)
        import_Mat.Mat.Inverse(parentTransform),
        newPagePoint
      );
      const newRotation = (0, import_utils2.canonicalizeRotation)(shape.rotation + delta);
      return {
        id: shape.id,
        type: shape.type,
        x: newLocalPoint.x,
        y: newLocalPoint.y,
        rotation: newRotation
      };
    })
  );
  const changes = [];
  shapeSnapshots.forEach(({ shape }) => {
    const current = editor.getShape(shape.id);
    if (!current) return;
    const util = editor.getShapeUtil(shape);
    if (stage === "start" || stage === "one-off") {
      const changeStart = util.onRotateStart?.(shape);
      if (changeStart) changes.push(changeStart);
    }
    const changeUpdate = util.onRotate?.(shape, current);
    if (changeUpdate) changes.push(changeUpdate);
    if (stage === "end" || stage === "one-off") {
      const changeEnd = util.onRotateEnd?.(shape, current);
      if (changeEnd) changes.push(changeEnd);
    }
  });
  if (changes.length > 0) {
    editor.updateShapes(changes);
  }
}
//# sourceMappingURL=rotation.js.map
